% KM-FILM code for making Figure 5 in Lakey at al. Indoor Air, 31, 6, 2070-2083 (2021)


%Layers
%1 Mean free path
%2: L_BL_close+1 Boundary layer close to the surface
%L_BL_close+2:L_BL_close+L_BL_far+1 Boundary layer further away from the surface
%L_BL_close+L_BL_far+2 Gas phase
%L_BL_close+L_BL_far+3 Sorption layer
%L_BL_close+L_BL_far+4:L_BL_close+L_BL_far+3+L_bulk Bulk film layers

%%%NOTE: This code takes approximately 24 hours to fully run%%%%
clear all
warning off all

global W sigma Db L_BL_close L_BL_far kbr
global a0 kd V_BL_close
global V_BL_far delta_BL_close delta_BL_far Dg_eddy Koa
global V_w L_bulk NCom mfp delta_x A ka

%%%%%General parameters for the different species%%%%%%
NCom=8; %Number of species
NA=6.02e23; %Avogadro's number (mol-1)
R=8.31e7;%Gas constant (g cm2 s-2 K-1 mol-1)
T=298;%Temperature (K)

%Eight species are included in the model with different log Koa values as follows:
%Species 1: Average log Koa= 7.5
Mx(1)=250; %Molar mass (g mol-1)
Dg(1)=0.04; %Gas-phase diffusion coefficient (cm2 s-1)
Db(1)=1e-10; %Bulk diffusion coefficient (cm2 s-1)
a0(1)=1; %Surface mass accommodation on an adsorbate free surface
logKoai(1)=7.5; %Log octanal-air partitioning coefficient
Cti(1)=0; %Total airborne concentration (g cm-3)

%Species 2: Average log Koa= 8.5
Mx(2)=250; %Molar mass (g mol-1)
Dg(2)=0.04; %Gas-phase diffusion coefficient (cm2 s-1)
Db(2)=1e-10; %Bulk diffusion coefficient (cm2 s-1)
a0(2)=1; %Surface mass accommodation on an adsorbate free surface
logKoai(2)=8.5; %Log octanal-air partitioning coefficient
Cti(2)=20e-6/1e6; %Total airborne concentration (g cm-3)

%Species 3: Average log Koa= 9.5
Mx(3)=250; %Molar mass (g mol-1)
Dg(3)=0.04; %Gas-phase diffusion coefficient (cm2 s-1)
Db(3)=1e-10; %Bulk diffusion coefficient (cm2 s-1)
a0(3)=1; %Surface mass accommodation on an adsorbate free surface
logKoai(3)=9.5; %Log octanal-air partitioning coefficient
Cti(3)=15e-6/1e6; %Total airborne concentration (g cm-3)

%Species 4: Average log Koa= 10.5
Mx(4)=250; %Molar mass (g mol-1)
Dg(4)=0.04; %Gas-phase diffusion coefficient (cm2 s-1)
Db(4)=1e-10; %Bulk diffusion coefficient (cm2 s-1)
a0(4)=1; %Surface mass accommodation on an adsorbate free surface
logKoai(4)=10.5; %Log octanal-air partitioning coefficient
Cti(4)=10e-6/1e6; %Total airborne concentration (g cm-3)

%Species 5: Average log Koa= 11.5
Mx(5)=250; %Molar mass (g mol-1)
Dg(5)=0.04; %Gas-phase diffusion coefficient (cm2 s-1)
Db(5)=1e-10; %Bulk diffusion coefficient (cm2 s-1)
a0(5)=1; %Surface mass accommodation on an adsorbate free surface
logKoai(5)=11.5; %Log octanal-air partitioning coefficient
Cti(5)=5e-6/1e6; %Total airborne concentration (g cm-3)

%Species 6: Average log Koa= 12.5
Mx(6)=250; %Molar mass (g mol-1)
Dg(6)=0.04; %Gas-phase diffusion coefficient (cm2 s-1)
Db(6)=1e-10; %Bulk diffusion coefficient (cm2 s-1)
a0(6)=1; %Surface mass accommodation on an adsorbate free surface
logKoai(6)=12.5; %Log octanal-air partitioning coefficient
Cti(6)=2e-6/1e6; %Total airborne concentration (g cm-3)

%Species 7:Non-volatile product when Species 2 reacts with species 6
Mx(7)=500; %Molar mass (g mol-1)
Db(7)=1e-10; %Bulk diffusion coefficient (cm2 s-1)

%Species 8: Non-volatile initial film compound
Mx(8)=250; %Molar mass (g mol-1)
Db(8)=1e-10; %Bulk diffusion coefficient (cm2 s-1)

%For all species:
for i=1:NCom
Dens(i)=1; %Density of the species (g cm-3)
V_w(i)=Mx(i)/NA/Dens(i); %Volume of one molecule (cm3)
delta_x(i)=V_w(i)^(1/3); %Geometrical diameter (cm)
sigma(i)=delta_x(i)^2; %Effective molecular cross section (cm2)
W(i)=sqrt(8*R*T/pi/Mx(i)); %Mean thermal velocity (cm s-1)
kd(i)=1e9; %Desorption rate from the surface (s-1)
end
for i=1:6
    mfp(i)= ((3*Dg(i))/W(i)); %Mean free path (cm)
    ka(i)=a0(i)*W(i)/4; %Adsorption rate on an adsorbate free surface (cm s-1)
end

kbr=0; %Reaction rate coefficient for Species 2 reacting with Species 6 (cm3 s-1)

%%%%%Other parameters%%%%%

fom_TSP=0.4;% Volume fraction of organic matter in particles (unitless)
TSP=20e-6/1e6; %Total airborne suspended particle concentration (g cm-3)
p_part=1;% bulk-phase density of airborne particles (g cm-3)
for i=1:6
    Koa(i)=10^(logKoai(i)); %Octanal-air partitioning coefficient (unitless)
    Kpi(i)=fom_TSP*Koa(i)/p_part;% Particle-air partitioning coefficient (cm3 g-1)
end
for i=1:6
    Cgi(i)=Cti(i)/(TSP*Kpi(i)+1);% Gas-phase concentration (g cm-3)
end

%%%%%%Boundary layer parameters%%%%%%
A=1; %Surface area of the film (cm2)
Ke=0;% Turbulence intensity (s-1)
BL_close=1e-4; %thickness of the boundary layer closest to the film (cm)
BL_far=0.04/(300/3600); %thickness of the boundary layer further away from the surface (cm)
L_BL_close=10; %Number of layers in the closest boundary layer
L_BL_far=10; %Number of layers in the boundary layer further away from the surface
delta_BL_close=BL_close./L_BL_close;%Thickness of each layer in the closest boundary layer (cm)
delta_BL_far=BL_far./L_BL_far;%Thickness of each layer in the boundary layer further away from the surface (cm)
V_BL_close=delta_BL_close.*A;%Volume of each layer in the closest boundary layer (cm3)
V_BL_far=delta_BL_far.*A;%Volume of each layer in the boundary layer further away from the surface(cm3)

Dist_from_surf(1,1)=mfp(1); %Distance from the surface to the gas-phase layer closest to the surface (cm)
for i=1:L_BL_close
    Dist_from_surf(i+1,1)=Dist_from_surf(i,1)+delta_BL_close; %Distance from the surface to the gas-phase layers in the closest boundary layer (cm)
end
for i=1:L_BL_far
    Dist_from_surf(i+1+L_BL_close,1)=Dist_from_surf(L_BL_close+i,1)+delta_BL_far;%Distance from the surface to the gas-phase layers in the boundary layer further away from the surface(cm)
end

for i=1:6
    for j=1:L_BL_close+L_BL_far+1
    Dg_eddy(i,j)=Dg(i)+Ke*(Dist_from_surf(j,1))^2; %Gas-phase diffusion coefficient in all boundary layers including turbulence (cm2 s-1)
    end
end

%%%%Critical thicknesses where the layers in KM-FILM merge or split%%%%
Two_monolayers=delta_x(1)*2; %Thickness of 2 monolayers (cm)
Minimum_layer_thickness=delta_x(1)/2; %Thickness of half a monolayer (cm)

%Each loop below will run for the equivalent of 24 hours before checks are
%performed to see whether the thickness in any bulk layer has exceeded to
%monolayers or become less than half a monolayer. If this has occured the 
%time length of a loop will subsequently be shortened to the time point 
%where this has occured.

for MM=1:550
    MM_output=MM %Allows progress to be monitored. The model will finish when MM=550.
    if MM==1
        L_bulk=4; %Initial number of layers in the film bulk

%%%%%Initial conditions%%%%%
y0=zeros((L_BL_close+L_BL_far+3+L_bulk)*NCom,1);
%Gas-phase concentration of Species 1 (cm-3)
y0((L_BL_close+L_BL_far+3+L_bulk)*(1-1)+L_BL_close+L_BL_far+2)=Cgi(1)/Mx(1)*6.02e23; %molec cm-3
%Gas-phase concentration of Species 1 (cm-3)
y0((L_BL_close+L_BL_far+3+L_bulk)*(2-1)+L_BL_close+L_BL_far+2)=Cgi(2)/Mx(2)*6.02e23; %molec cm-3
%Gas-phase concentration of Species 1 (cm-3)
y0((L_BL_close+L_BL_far+3+L_bulk)*(3-1)+L_BL_close+L_BL_far+2)=Cgi(3)/Mx(3)*6.02e23; %molec cm-3
%Gas-phase concentration of Species 1 (cm-3)
y0((L_BL_close+L_BL_far+3+L_bulk)*(4-1)+L_BL_close+L_BL_far+2)=Cgi(4)/Mx(4)*6.02e23; %molec cm-3
%Gas-phase concentration of Species 1 (cm-3)
y0((L_BL_close+L_BL_far+3+L_bulk)*(5-1)+L_BL_close+L_BL_far+2)=Cgi(5)/Mx(5)*6.02e23; %molec cm-3
%Gas-phase concentration of Species 1 (cm-3)
y0((L_BL_close+L_BL_far+3+L_bulk)*(6-1)+L_BL_close+L_BL_far+2)=Cgi(6)/Mx(6)*6.02e23; %molec cm-3

for j=L_BL_close+L_BL_far+4:L_BL_close+L_BL_far+3+L_bulk
%Number of molecules of Species 8 in each bulk layer
    y0((L_BL_close+L_BL_far+3+L_bulk)*(8-1)+j)=2e-7.*A./L_bulk./V_w(8);
end

        % %***********Solve differential equations*********
n=250; %Number of time points outputted for each loop
t=logspace(-3,log10(3600*24),n);t=t'; %time being investigated in each loop (s)
AbsTol=1;
RelTol=1e-3;
options=odeset('AbsTol',AbsTol,'RelTol',RelTol);
[X,Y]=ode23tb(@Film_growth_KMFILM_F,t,y0); %solver
AA=0;
    else
        
        CC=size(Y,1); %number of time steps
clear Total_thickness
        for i=1:CC
            for j=1:L_bulk+1
                for m=L_BL_close+L_BL_far+L_bulk+3
        %Total thickness of the sorption layer and each bulk layer (cm):
        Total_thickness(i,j)=(V_w(1)*Y(i,(m*(1-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(2)*Y(i,(m*(2-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(3)*Y(i,(m*(3-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(4)*Y(i,(m*(4-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(5)*Y(i,(m*(5-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(6)*Y(i,(m*(6-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(7)*Y(i,(m*(7-1)+L_BL_close+L_BL_far+2+j))+...
        V_w(8)*Y(i,(m*(8-1)+L_BL_close+L_BL_far+2+j)))./A;
        %Number of molecules of Species 1-8 in the sorption layer and each bulk layer
        Species1_1(i,j)=(Y(i,(m*(1-1)+L_BL_close+L_BL_far+2+j)));
        Species2_1(i,j)=(Y(i,(m*(2-1)+L_BL_close+L_BL_far+2+j)));
        Species3_1(i,j)=(Y(i,(m*(3-1)+L_BL_close+L_BL_far+2+j)));
        Species4_1(i,j)=(Y(i,(m*(4-1)+L_BL_close+L_BL_far+2+j)));
        Species5_1(i,j)=(Y(i,(m*(5-1)+L_BL_close+L_BL_far+2+j)));
        Species6_1(i,j)=(Y(i,(m*(6-1)+L_BL_close+L_BL_far+2+j)));
        Species7_1(i,j)=(Y(i,(m*(7-1)+L_BL_close+L_BL_far+2+j)));
        Species8_1(i,j)=(Y(i,(m*(8-1)+L_BL_close+L_BL_far+2+j)));
                end
            end
        end
        clear thickness_total
for i=1:CC
 %Total thickness of all layers (cm)
 thickness_total(1,i)=sum(Total_thickness(i,1:L_bulk+1));
 %Total number of molecules of Species 1-8 in the film:
 Species1(i,1)=sum(Species1_1(i,1:L_bulk+1));
 Species2(i,1)=sum(Species2_1(i,1:L_bulk+1));
 Species3(i,1)=sum(Species3_1(i,1:L_bulk+1));
 Species4(i,1)=sum(Species4_1(i,1:L_bulk+1));
 Species5(i,1)=sum(Species5_1(i,1:L_bulk+1));
 Species6(i,1)=sum(Species6_1(i,1:L_bulk+1));
 Species7(i,1)=sum(Species7_1(i,1:L_bulk+1));
 Species8(i,1)=sum(Species8_1(i,1:L_bulk+1));
 end
        clear B_1 B_2
for i=1:L_bulk
    for j=1:CC
 B_1(i,j) = Total_thickness(j,i+1) > Two_monolayers; %If a layer is thicker than 2 monolayers B_1 will equal 1 otherwise it will equal zero
 B_2(i,j) = Total_thickness(j,i+1) < Minimum_layer_thickness; %If a layer is thinner than half a monolayer B_2 will equal 1 otherwise it will equal zero
    end
end
    clear B B2
for j=1:CC
     B(1,j)=sum(B_1(1:L_bulk,j)); %sum of B_1 values over all layers for each time step
     B2(1,j)=sum(B_2(1:L_bulk,j)); %sum of B_2 values over all layers for each time step
end

if B(1,CC)==0 %i.e. No layers exceed 2 monolayers in thickness
    column_value=CC; %number of time steps doesn't change    
else
column_value = [strfind([~B(1),B],[0 1])]; %time step when a layer exceeds two monolayers in thickness

end
 if B2(1,CC)==0 %i.e. No layers are less than half a monolayer in thickness
   column_value_2=CC; %number of time steps doesn't change
 else
column_value_2= [strfind([~B2(1),B2],[0 1])]; %time step when a layer is less than half a monolayer in thickness
 end
%%%%%OUTPUTS%%%%%%%%
if column_value_2(1,1)<column_value(1,1) %layer is less than half a monolayer occurs before layer is more than 2 monolayers
    for i=AA+1:AA+column_value_2 %values will only be outputted up to the time-point where a layer is less than half a monolayer in thickness
        if AA==0
                aa_time_output(i,1)=t(i-AA,1); %Outputted time (s)
    else
    aa_time_output(i,1)=aa_time_output(AA,1)+t(i-AA,1); %Outputted time (s)
        end
    aa_output_thickness(i,1)=thickness_total(1,i-AA); %Outputted total thickness (cm)
    aa_Species1_thickness(i,1)=Species1(i-AA,1).*V_w(1)./A; %Contribution of Species 1 to the thickness (cm)
    aa_Species2_thickness(i,1)=Species2(i-AA,1).*V_w(2)./A; %Contribution of Species 2 to the thickness (cm)
    aa_Species3_thickness(i,1)=Species3(i-AA,1).*V_w(3)./A; %Contribution of Species 3 to the thickness (cm)
    aa_Species4_thickness(i,1)=Species4(i-AA,1).*V_w(4)./A; %Contribution of Species 4 to the thickness (cm)
    aa_Species5_thickness(i,1)=Species5(i-AA,1).*V_w(5)./A; %Contribution of Species 5 to the thickness (cm)
    aa_Species6_thickness(i,1)=Species6(i-AA,1).*V_w(6)./A; %Contribution of Species 6 to the thickness (cm)
    aa_Species7_thickness(i,1)=Species7(i-AA,1).*V_w(7)./A; %Contribution of Species 7 to the thickness (cm)
    aa_Species8_thickness(i,1)=Species8(i-AA,1).*V_w(8)./A; %Contribution of Species 8 to the thickness (cm)
    aa_output_bulk_layers(i,1)=L_bulk; %Total number of bulk layers

    end
else
for i=AA+1:AA+column_value(1,1)
    if AA==0
        aa_time_output(i,1)=t(i-AA,1); %Outputted time (s)
    else
    aa_time_output(i,1)=aa_time_output(AA,1)+t(i-AA,1); %Outputted time (s)
    end
    aa_output_thickness(i,1)=thickness_total(1,i-AA); %Outputted total thickness (cm)
    aa_Species1_thickness(i,1)=Species1(i-AA,1).*V_w(1)./A; %Contribution of Species 1 to the thickness (cm)
    aa_Species2_thickness(i,1)=Species2(i-AA,1).*V_w(2)./A; %Contribution of Species 2 to the thickness (cm)
    aa_Species3_thickness(i,1)=Species3(i-AA,1).*V_w(3)./A; %Contribution of Species 3 to the thickness (cm)
    aa_Species4_thickness(i,1)=Species4(i-AA,1).*V_w(4)./A; %Contribution of Species 4 to the thickness (cm)
    aa_Species5_thickness(i,1)=Species5(i-AA,1).*V_w(5)./A; %Contribution of Species 5 to the thickness (cm)
    aa_Species6_thickness(i,1)=Species6(i-AA,1).*V_w(6)./A; %Contribution of Species 6 to the thickness (cm)
    aa_Species7_thickness(i,1)=Species7(i-AA,1).*V_w(7)./A; %Contribution of Species 7 to the thickness (cm)
    aa_Species8_thickness(i,1)=Species8(i-AA,1).*V_w(8)./A; %Contribution of Species 8 to the thickness (cm)
    aa_output_bulk_layers(i,1)=L_bulk; %Total number of bulk layers

end
end

if column_value_2(1,1)<column_value(1,1)
AA=AA+column_value_2(1,1); %New AA value based on number of time steps being outputted
else
AA=AA+column_value(1,1); %New AA value based on number of time steps being outputted
end

%%%%%%CODE IF NO LAYER EXCEEDS 2 MONOLAYERS OR IS THINNER THAN HALF A MONOLAYER IN THICKNESS%%%%%%%%%%
if column_value(1,1)==CC && column_value_2(1,1)==CC
        L_bulk=L_bulk; %Number of bulk layers remains the same

% Initial conditions for the next loop (final value from the previous loop is taken)
    j=L_BL_close+L_BL_far+3+L_bulk;
for m=1:L_BL_close+L_BL_far+2
for i=1:NCom
    %Gas-phase layer and boundary layer concentrations for the next loop (molec cm-3)
    y0((i-1)*j+m)=Y(column_value(1,1),(i-1)*j+m); 
    %Number of molecules in the sorption layer
    y0((i-1)*j+L_BL_close+L_BL_far+3)=Y(column_value(1,1),(i-1)*j+L_BL_close+L_BL_far+3);
    %Number of molecules in the first bulk layer
    y0((i-1)*j+L_BL_close+L_BL_far+4)=Y(column_value(1,1),(i-1)*j+L_BL_close+L_BL_far+4);
    %Number of molecules in all other bulk layers
    for k=1:L_bulk-1
    y0((i-1)*j+L_BL_close+L_BL_far+4+k)=Y(column_value(1,1),(i-1)*j+L_BL_close+L_BL_far+4+k);    
    end
end
end
%%%%%CODE FOR LAYER SPLITTING, LAYER EXCEEDS TWO MONOLAYERS%%%%%%
elseif column_value(1,1)<=column_value_2(1,1)
BB=find(B_1(:,column_value(1,1))==1); %Bulk layer number which exceeds two monolayers
    L_bulk=L_bulk+1; %Bulk layers increase by 1

% Initial conditions for the next loop
y0=zeros((L_BL_close+L_BL_far+3+L_bulk)*NCom,1);
    j=L_BL_close+L_BL_far+3+L_bulk;
for m=1:L_BL_close+L_BL_far+2
for i=1:NCom
    %Gas-phase layer and boundary layer concentrations for the next loop (molec cm-3)
    y0((i-1)*j+m)=Y(column_value(1,1),(i-1)*(j-1)+m); 
    %Number of molecules in the sorption layer
    y0((i-1)*j+L_BL_close+L_BL_far+3)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3);%surface layer
    %Number of molecules in the bulk layers
    if BB==1 %If bulk layer 1 exceeds two monolayers in thickness
    %Molecules are split equally between the first two layers
    y0((i-1)*j+L_BL_close+L_BL_far+4)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+4)./2;
    y0((i-1)*j+L_BL_close+L_BL_far+5)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+4)./2;
    for k=1:L_bulk-2
    %Molecules in all other layers remain the same
    y0((i-1)*j+L_BL_close+L_BL_far+5+k)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+4+k);    
    end
    elseif BB==L_bulk-1 %If the final bulk layer exceeds two monolayers in thickness
        for k=1:L_bulk-2
    %Molecules in all other layers remain the same
            y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+k);
        end
    %Molecules are split equally between the last two layers
        y0((i-1)*j+L_BL_close+L_BL_far+3+L_bulk-1)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+L_bulk-1)./2;
        y0((i-1)*j+L_BL_close+L_BL_far+3+L_bulk)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+L_bulk-1)./2;
    else % if any other bulk layer exceeds two monolayers in thickness
    for k=1:BB-1
    %Molecules in all other layers remain the same
       y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+k);
    end
    for k=BB
    %Molecules are split equally between two layers
      y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+k)./2;  
      y0((i-1)*j+L_BL_close+L_BL_far+3+k+1)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+k)./2;        
    end
    %Molecules in all other layers remain the same
    for k=BB+2:L_bulk
    y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value(1,1),(i-1)*(j-1)+L_BL_close+L_BL_far+3+k-1);    
    end
    end
end
end
%%%%%CODE FOR LAYER MERGING, LAYER IS THINNER THAN HALF A MONOLAYER%%%%%%
else
BB=find(B_2(:,column_value_2(1,1))==1); %Bulk layer number which is thinner than half a monolayer
    L_bulk=L_bulk-1; %Bulk layers decrease by 1
%initial conditions
clear y0
y0=zeros((L_BL_close+L_BL_far+3+L_bulk)*NCom,1);
    j=L_BL_close+L_BL_far+3+L_bulk;
for m=1:L_BL_close+L_BL_far+2
for i=1:NCom
    %Gas-phase layer and boundary layer concentrations for the next loop (molec cm-3)
    y0((i-1)*j+m)=Y(column_value_2(1,1),(i-1)*(j+1)+m); 
    %Number of molecules in the sorption layer
    y0((i-1)*j+L_BL_close+L_BL_far+3)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+3);%surface layer
    %Number of molecules in the bulk layers
    if BB==1 %If bulk layer 1 is thinner than half a monolayer in thickness
    % Layers 1 and 2 merge
    y0((i-1)*j+L_BL_close+L_BL_far+4)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+4)+Y(column_value_2,(i-1)*(j+1)+L_BL_close+L_BL_far+5);
    %Molecules in all other layers remain the same
    for k=1:L_bulk-1
     y0((i-1)*j+L_BL_close+L_BL_far+4+k)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+4+k+1);    
    end
    elseif BB==L_bulk+1 %If the final bulk layer is thinner than half a monolayer in thickness
    %Molecules in all other layers remain the same    
        for k=1:L_bulk-1
        y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+3+k);    
        end
    %The final bulk layer merges with the one just above it
        y0((i-1)*j+L_BL_close+L_BL_far+3+L_bulk)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+3+L_bulk)+Y(column_value_2,(i-1)*(j+1)+L_BL_close+L_BL_far+3+L_bulk+1);   
    else % if any other bulk layer is thinner than half a monolayer in thickness
        for k=1:BB-1
        %Molecules in all other layers remain the same 
        y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+3+k);
        end
        for k=BB
        %The layer that is less than half a monolayer in thickness merges with the next layer
        y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+3+k)+Y(column_value_2,(i-1)*(j+1)+L_BL_close+L_BL_far+3+k+1);    
        end
        if BB<L_bulk
            for k=BB+1:L_bulk
        %Molecules in all other layers remain the same 
        y0((i-1)*j+L_BL_close+L_BL_far+3+k)=Y(column_value_2(1,1),(i-1)*(j+1)+L_BL_close+L_BL_far+3+k+1);
            end    
        end
end
end
end
end

%***********Solve differential equations*********

n=250;%Number of time points outputted for each loop
t=logspace(-3,log10(3600*24),n);t=t';
AbsTol=1;
RelTol=1e-3;
options=odeset('AbsTol',AbsTol,'RelTol',RelTol);%time being investigated in each loop (s)
[X,Y]=ode23tb(@Film_growth_KMFILM_F,t,y0);%solver

    end
end

%Figures
figure(1)
plot(aa_time_output(:,1)/(3600*24),aa_output_thickness(:,1)*1e7)
xlabel('Time (days)')
ylabel('Total film thickness (nm)')
        
figure(2)
plot(aa_time_output(:,1)/(3600*24),aa_Species1_thickness(:,1)*1e7)
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species2_thickness(:,1)*1e7,'r')
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species3_thickness(:,1)*1e7,'m')
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species4_thickness(:,1)*1e7,'y')
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species5_thickness(:,1)*1e7,'g')
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species6_thickness(:,1)*1e7,'b')
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species7_thickness(:,1)*1e7)
hold on
plot(aa_time_output(:,1)/(3600*24),aa_Species8_thickness(:,1)*1e7,'k')
xlabel('Time (days)')
ylabel('Contribution of species to the film thickness (nm)')
legend('logKoa=7.5','logKoa=8.5','logKoa=9.5','logKoa=10.5','logKoa=11.5','logKoa=12.5','Non-volatile product','Initial film compound')

figure(3)
plot(aa_time_output(:,1)/(3600*24),aa_output_bulk_layers(:,1))
xlabel('Time (days)')
ylabel('Number of layers in the bulk')